# -*- coding: UTF-8 -*-
# /*
# *      Copyright (C) 2013 Libor Zoubek
# *
# *
# *  This Program is free software; you can redistribute it and/or modify
# *  it under the terms of the GNU General Public License as published by
# *  the Free Software Foundation; either version 2, or (at your option)
# *  any later version.
# *
# *  This Program is distributed in the hope that it will be useful,
# *  but WITHOUT ANY WARRANTY; without even the implied warranty of
# *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# *  GNU General Public License for more details.
# *
# *  You should have received a copy of the GNU General Public License
# *  along with this program; see the file COPYING.  If not, write to
# *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
# *  http://www.gnu.org/copyleft/gpl.html
# *
# */
import os

sys.path.append(os.path.join (os.path.dirname(__file__), 'resources', 'lib'))
import videacesky

import xbmc
import xbmcvfs
import xbmcaddon
import xbmcgui
import xbmcplugin
import util
import xbmcprovider
import xbmcutil
import resolver

from provider import ResolveException

__scriptid__ = 'plugin.video.videacesky.cz'
__scriptname__ = 'videacesky.cz'
__addon__ = xbmcaddon.Addon(id=__scriptid__)
__language__ = __addon__.getLocalizedString
__settings__ = __addon__.getSetting

# sys.path.append(os.path.join(__addon__.getAddonInfo('path'), 'resources', 'lib'))

settings = {'downloads': __addon__.getSetting('downloads'), 'quality': __addon__.getSetting('quality')}


def vp8_youtube_filter(stream):
	# some embedded devices running xbmc doesnt have vp8 support, so we
	# provide filtering ability for youtube videos

	#======================================================================
	# 	  5: "240p h263 flv container",
	#      18: "360p h264 mp4 container | 270 for rtmpe?",
	#      22: "720p h264 mp4 container",
	#      26: "???",
	#      33: "???",
	#      34: "360p h264 flv container",
	#      35: "480p h264 flv container",
	#      37: "1080p h264 mp4 container",
	#      38: "720p vp8 webm container",
	#      43: "360p h264 flv container",
	#      44: "480p vp8 webm container",
	#      45: "720p vp8 webm container",
	#      46: "520p vp8 webm stereo",
	#      59: "480 for rtmpe",
	#      78: "seems to be around 400 for rtmpe",
	#      82: "360p h264 stereo",
	#      83: "240p h264 stereo",
	#      84: "720p h264 stereo",
	#      85: "520p h264 stereo",
	#      100: "360p vp8 webm stereo",
	#      101: "480p vp8 webm stereo",
	#      102: "720p vp8 webm stereo",
	#      120: "hd720",
	#      121: "hd1080"
	#======================================================================
	try:
		if stream['fmt'] in [38, 44, 45, 46, 100, 101, 102]:
			return True
	except KeyError:
		return False
	return False


class VideaceskyXBMCContentProvider(xbmcprovider.XBMCMultiResolverContentProvider):
    def play(self, item):
        stream = self.resolve(item['url'])
        if type(stream) == type([]):
            # resolved to mutliple files, we'll feed playlist and play the first one
            playlist = xbmc.PlayList(xbmc.PLAYLIST_VIDEO)
            playlist.clear()
            for video in stream:
                li = xbmcgui.ListItem(label=video['title'], path=video['url'])
                li.setArt({'icon':'DefaultVideo.png'})
                if video['subs'] != None and video['subs'] != '':
                    li.setSubtitles([video['subs']])

                playlist.add(video['url'], li)
            stream = stream[0]
        if stream:
            xbmcutil.reportUsage(self.addon_id, self.addon_id + '/play')
            if 'headers' in stream.keys():
                for header in stream['headers']:
                    stream['url'] += '|%s=%s' % (header, stream['headers'][header])
            print('Sending %s to player' % stream['url'])
            li = xbmcgui.ListItem(path=stream['url'])
            li.setArt({'icon':'DefaultVideo.png'})

            sub = False
            if xbmcaddon.Addon('xbmc.addon').getAddonInfo('version') > "16":
                sub = True
                if stream['subs'] != None and stream['subs'] != '':
                    li.setSubtitles([stream['subs']])

            xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, li)
            if sub == False:
                xbmcutil.load_subtitles(stream['subs'])

    def resolve(self, url):
        def select_cb(resolved):
            stream_parts = []
            stream_parts_dict = {}

            for stream in resolved:
                if stream['surl'] not in stream_parts_dict:
                    stream_parts_dict[stream['surl']] = []
                    stream_parts.append(stream['surl'])
                if __settings__('filter_vp8') and vp8_youtube_filter(stream):
                    continue
                stream_parts_dict[stream['surl']].append(stream)

            if len(stream_parts) == 1:
                dialog = xbmcgui.Dialog()
                quality = self.settings['quality'] or '0'
                resolved = resolver.filter_by_quality(stream_parts_dict[stream_parts[0]], quality)
                # if user requested something but 'ask me' or filtered result is exactly 1
                if len(resolved) == 1 or int(quality) > 0:
                    return resolved[0]
                opts = ['%s [%s]' % (r['title'], r['quality']) for r in resolved]
                ret = dialog.select(xbmcutil.__lang__(30005), opts)
                return resolved[ret]

            dialog = xbmcgui.Dialog()
            opts = [__language__(30059)]
            # when there are multiple stream, we let user choose only from best qualities
            opts = opts + ['%s [%s]' % (stream_parts_dict[p][0]['title'], stream_parts_dict[p][0]['quality']) for p in stream_parts]
            ret = dialog.select(xbmcutil.__lang__(30005), opts)
            if ret == 0:
                # requested to play all streams in given order - so return them all
                return [stream_parts_dict[p][0] for p in stream_parts]
            if ret >= 0:
               return stream_parts_dict[stream_parts[ret-1]][0]

        item = self.provider.video_item()
        item.update({'url':url})
        try:
            return self.provider.resolve(item, select_cb=select_cb)
        except ResolveException as e:
            self._handle_exc(e)

params = util.params()
if params == {}:
	xbmcutil.init_usage_reporting(__scriptid__)
# VideaceskyXBMCContentProvider(videacesky.VideaceskyContentProvider(tmp_dir=xbmc.translatePath(__addon__.getAddonInfo('profile'))), settings, __addon__).run(params)
original_yt = __settings__('original_yt') == 'true'
vc = videacesky.VideaceskyContentProvider(original_yt=original_yt, tmp_dir=xbmcvfs.translatePath(__addon__.getAddonInfo('profile')))

VideaceskyXBMCContentProvider(vc, settings, __addon__).run(params)
