# -*- coding: utf-8 -*-
import sys
import xbmcplugin
import xbmcgui

from datetime import datetime

from libs.session import Session
from libs.o2tv import O2API
from libs.channels import Channels
from libs.epg import epg_api, epg_listitem
from libs.utils import get_url, encode, decode, day_translation_short

_handle = int(sys.argv[1])

def list_categories(label):
    xbmcplugin.setPluginCategory(_handle, label)
    categories = []
    session = Session()
    o2api = O2API()
    post = {"language":"ces","ks":session.ks,"deviceFamilyId":5,"clientTag":"1.16.1-PC","apiVersion":"5.4.0"}
    data = o2api.call_o2_api(url = 'https://3201.frp1.ott.kaltura.com/api_v3/service/categorytree/action/getByVersion?format=1&clientTag=1.16.1-PC', data = post, headers = o2api.headers)
    if 'err' in data or not 'result' in data or len(data['result']) == 0 or 'children' not in data['result'] or len(data['result']['children']) == 0:
        xbmcgui.Dialog().notification('O2TV','Problém při načtení kategorií', xbmcgui.NOTIFICATION_ERROR, 5000)
        sys.exit() 
    for item in data['result']['children']:
        if item['id'] == 614494:
            for category in item['children']:
                print(category)
                if 'unifiedChannels' in category and len(category['unifiedChannels']) > 0:
                    categories.append({'id' : category['id'], 'category_id' : category['unifiedChannels'][0]['id'], 'name' : category['name']})

    for category in categories:
        list_item = xbmcgui.ListItem(label=encode(category['name']))
        url = get_url(action='list_category', id = category['category_id'], label = label + ' / ' + encode(category['name']))  
        xbmcplugin.addDirectoryItem(_handle, url, list_item, True)
    xbmcplugin.endOfDirectory(_handle)              

def list_category(id, label):
    xbmcplugin.setPluginCategory(_handle, label)
    session = Session()

    channels = Channels()
    channels_list = channels.get_channels_list('id', visible_filter = False)            

    # post = {"language":"ces","ks":session.ks,"filter":{"objectType":"KalturaSearchAssetFilter","kSql":"(and (or CategoryId = '614739' CategoryId = '614396' CategoryId = '614395' CategoryId = '614388' CategoryId = '614389' CategoryId = '614390' CategoryId = '614391' CategoryId = '614392' CategoryId = '614393' CategoryId = '614394' CategoryId = '614406' CategoryId = '614397' CategoryId = '614398' CategoryId = '614399' CategoryId = '614400' CategoryId = '614401' CategoryId = '614402' CategoryId = '614403' CategoryId = '614745' CategoryId = '614404' CategoryId = '614405' CategoryId = '614416' CategoryId = '614407' CategoryId = '614408' CategoryId = '614409' CategoryId = '614410' CategoryId = '614411' CategoryId = '614412' CategoryId = '614413' CategoryId = '614414' CategoryId = '614415' CategoryId = '614426' CategoryId = '614417' CategoryId = '614418' CategoryId = '614419' CategoryId = '614420' CategoryId = '614421' CategoryId = '614422' CategoryId = '614423' CategoryId = '614424' CategoryId = '614425' CategoryId = '614436' CategoryId = '614427' CategoryId = '614744' CategoryId = '614428' CategoryId = '614429' CategoryId = '614430' CategoryId = '614431' CategoryId = '614432' CategoryId = '614433' CategoryId = '614434' CategoryId = '614435' CategoryId = '614444' CategoryId = '614437' CategoryId = '614438' CategoryId = '614439' CategoryId = '614440' CategoryId = '614441' CategoryId = '614442' CategoryId = '614443' CategoryId = '614446' CategoryId = '614445' CategoryId = '614463' CategoryId = '614450' CategoryId = '614447' CategoryId = '614448' CategoryId = '614449' CategoryId = '614451' CategoryId = '614452' CategoryId = '614453' CategoryId = '614454' CategoryId = '614455' CategoryId = '614456' CategoryId = '614457' CategoryId = '614458' CategoryId = '614460' CategoryId = '614459' CategoryId = '614461' CategoryId = '614462' CategoryId = '614464' CategoryId = '614472' CategoryId = '614465' CategoryId = '614466' CategoryId = '614467' CategoryId = '614468' CategoryId = '614469' CategoryId = '614470' CategoryId = '614471' CategoryId = '614482' CategoryId = '614481' CategoryId = '614473' CategoryId = '614474' CategoryId = '614475' CategoryId = '614476' CategoryId = '614477' CategoryId = '614478' CategoryId = '614479' CategoryId = '614480' CategoryId = '614494' CategoryId = '614483' CategoryId = '614484' CategoryId = '614485' CategoryId = '614486' CategoryId = '614487' CategoryId = '614488' CategoryId = '614489' CategoryId = '614490' CategoryId = '614491' CategoryId = '614492' CategoryId = '614493' CategoryId = '614512' CategoryId = '614495' CategoryId = '614496' CategoryId = '614497' CategoryId = '614498' CategoryId = '614499' CategoryId = '614500' CategoryId = '614501' CategoryId = '614502' CategoryId = '614503' CategoryId = '614504' CategoryId = '614505' CategoryId = '614506' CategoryId = '614507' CategoryId = '614508' CategoryId = '614509' CategoryId = '614510' CategoryId = '614511' CategoryId = '614516' CategoryId = '614513' CategoryId = '614514' CategoryId = '614515' CategoryId = '614520' CategoryId = '614517' CategoryId = '614518' CategoryId = '614519' CategoryId = '614524' CategoryId = '614521' CategoryId = '614522' CategoryId = '614523' CategoryId = '614528' CategoryId = '614525' CategoryId = '614526' CategoryId = '614527' CategoryId = '614532' CategoryId = '614529' CategoryId = '614530' CategoryId = '614531' CategoryId = '614544' CategoryId = '614533' CategoryId = '614534' CategoryId = '614535' CategoryId = '614536' CategoryId = '614537' CategoryId = '614538' CategoryId = '614539' CategoryId = '614540' CategoryId = '614541' CategoryId = '614542' CategoryId = '614543' CategoryId = '614550' CategoryId = '614545' CategoryId = '614546' CategoryId = '614547' CategoryId = '614548' CategoryId = '614549' CategoryId = '614554' CategoryId = '614551' CategoryId = '614552' CategoryId = '614553' CategoryId = '614558' CategoryId = '614555' CategoryId = '614556' CategoryId = '614557' CategoryId = '614562' CategoryId = '614559' CategoryId = '614560' CategoryId = '614561' CategoryId = '614566' CategoryId = '614563' CategoryId = '614564' CategoryId = '614565' CategoryId = '614570' CategoryId = '614567' CategoryId = '614568' CategoryId = '614569' CategoryId = '614573' CategoryId = '614571' CategoryId = '614572' CategoryId = '614575' CategoryId = '614574' CategoryId = '614576' CategoryId = '614591' CategoryId = '614577' CategoryId = '614581' CategoryId = '614582' CategoryId = '614583' CategoryId = '614584' CategoryId = '614585' CategoryId = '614586' CategoryId = '614587' CategoryId = '614588' CategoryId = '614589' CategoryId = '614590' CategoryId = '614596' CategoryId = '614592' CategoryId = '614593' CategoryId = '614594' CategoryId = '614595' CategoryId = '614598' CategoryId = '614597' CategoryId = '614600' CategoryId = '614599' CategoryId = '614604' CategoryId = '614601' CategoryId = '614602' CategoryId = '614603' CategoryId = '614611' CategoryId = '614605' CategoryId = '614606' CategoryId = '614607' CategoryId = '614608' CategoryId = '614609' CategoryId = '614610' CategoryId = '614615' CategoryId = '614612' CategoryId = '614613' CategoryId = '614614' CategoryId = '614619' CategoryId = '614616' CategoryId = '614617' CategoryId = '614618' CategoryId = '614623' CategoryId = '614620' CategoryId = '614621' CategoryId = '614622' CategoryId = '614627' CategoryId = '614624' CategoryId = '614625' CategoryId = '614626' CategoryId = '614631' CategoryId = '614628' CategoryId = '614629' CategoryId = '614630' CategoryId = '614635' CategoryId = '614632' CategoryId = '614633' CategoryId = '614634' CategoryId = '614639' CategoryId = '614636' CategoryId = '614637' CategoryId = '614638' CategoryId = '614643' CategoryId = '614640' CategoryId = '614641' CategoryId = '614642' CategoryId = '614647' CategoryId = '614644' CategoryId = '614645' CategoryId = '614646' CategoryId = '614651' CategoryId = '614648' CategoryId = '614649' CategoryId = '614650' CategoryId = '614655' CategoryId = '614652' CategoryId = '614653' CategoryId = '614654' CategoryId = '614659' CategoryId = '614656' CategoryId = '614657' CategoryId = '614658' CategoryId = '614663' CategoryId = '614660' CategoryId = '614661' CategoryId = '614662' CategoryId = '614680' CategoryId = '614664' CategoryId = '614665' CategoryId = '614666' CategoryId = '614667' CategoryId = '614668' CategoryId = '614669' CategoryId = '614670' CategoryId = '614671' CategoryId = '614672' CategoryId = '614673' CategoryId = '614674' CategoryId = '614675' CategoryId = '614676' CategoryId = '614677' CategoryId = '614678' CategoryId = '614679' CategoryId = '614689' CategoryId = '614681' CategoryId = '614682' CategoryId = '614683' CategoryId = '614684' CategoryId = '614685' CategoryId = '614686' CategoryId = '614687' CategoryId = '614688' CategoryId = '614697' CategoryId = '614690' CategoryId = '614691' CategoryId = '614692' CategoryId = '614693' CategoryId = '614694' CategoryId = '614695' CategoryId = '614696' CategoryId = '614701' CategoryId = '614698' CategoryId = '614699' CategoryId = '614700' CategoryId = '614705' CategoryId = '614702' CategoryId = '614703' CategoryId = '614704' CategoryId = '614709' CategoryId = '614706' CategoryId = '614707' CategoryId = '614708' CategoryId = '614713' CategoryId = '614710' CategoryId = '614711' CategoryId = '614712' CategoryId = '614717' CategoryId = '614714' CategoryId = '614715' CategoryId = '614716' CategoryId = '614721' CategoryId = '614718' CategoryId = '614719' CategoryId = '614720' CategoryId = '614725' CategoryId = '614722' CategoryId = '614723' CategoryId = '614724' CategoryId = '614729' CategoryId = '614726' CategoryId = '614727' CategoryId = '614728' CategoryId = '614733' CategoryId = '614730' CategoryId = '614731' CategoryId = '614732' CategoryId = '614738' CategoryId = '614734' CategoryId = '614735' CategoryId = '614736' CategoryId = '614737' CategoryId = '614740' CategoryId = '614741' CategoryId = '614742' CategoryId = '614743' )(or ))"},"pager":{"objectType":"KalturaFilterPager","pageSize":100,"pageIndex":4},"clientTag":"1.16.1-PC","apiVersion":"5.4.0"}
    # post = {"language":"ces","ks":session.ks,"filter":{"objectType":"KalturaSearchAssetFilter","kSql":"(and CategoryId = '" + str(id) + "')"},"pager":{"objectType":"KalturaFilterPager","pageSize":500,"pageIndex":1},"clientTag":"1.16.1-PC","apiVersion":"5.4.0"}
    # post = {"language":"ces","ks":session.ks,"responseProfile":{"objectType":"KalturaOnDemandResponseProfile","relatedProfiles":[{"objectType":"KalturaDetachedResponseProfile","name":"group_result","filter":{"objectType":"KalturaAggregationCountFilter"}}],"retrievedProperties":"assetId, assetType, duration, finishedWatching, position, watchedDate, mediaFiles,description,objectType,name,id,images,tags,metas,epgChannelId,enableCatchUp,enableCdvr,enableStartOver,enableTrickPlay,linearAssetId,type,updateDate,externalId,epgId,endDate,createDate,crid,startDate"},"filter":{"objectType":"KalturaChannelFilter","kSql":"","groupBy":[{"objectType":"KalturaAssetMetaOrTagGroupBy","value":"name"}],"idEqual":id},"pager":{"objectType":"KalturaFilterPager","pageSize":500,"pageIndex":1},"clientTag":"1.16.1-PC","apiVersion":"5.4.0"}
    post = {"language":"ces","ks":session.ks,"responseProfile":{"objectType":"KalturaOnDemandResponseProfile","relatedProfiles":[{"objectType":"KalturaDetachedResponseProfile","name":"group_result","filter":{"objectType":"KalturaAggregationCountFilter"}}],"retrievedProperties":"assetId, assetType, duration, finishedWatching, position, watchedDate, mediaFiles,description,objectType,name,id,images,tags,metas,epgChannelId,enableCatchUp,enableCdvr,enableStartOver,enableTrickPlay,linearAssetId,type,updateDate,externalId,epgId,endDate,createDate,crid,startDate"},"filter":{"objectType":"KalturaChannelFilter","kSql":"","groupBy":[{"objectType":"KalturaAssetMetaOrTagGroupBy","value":"name"}],"idEqual":358534},"pager":{"objectType":"KalturaFilterPager","pageSize":25,"pageIndex":1},"clientTag":"1.16.1-PC","apiVersion":"5.4.0"}
    epg = epg_api(post = post, key = 'startts')
    for key in sorted(epg.keys(), reverse = False):
        # list_item = xbmcgui.ListItem(label = epg[key]['title'] + ' (' + channels_list[epg[key]['channel_id']]['name'] + ' | ' + decode(day_translation_short[datetime.fromtimestamp(epg[key]['startts']).strftime('%w')]) + ' ' + datetime.fromtimestamp(epg[key]['startts']).strftime('%d.%m %H:%M') + ' - ' + datetime.fromtimestamp(epg[key]['endts']).strftime('%H:%M') + ')')        
        list_item = xbmcgui.ListItem(label = epg[key]['title'] + ' (' +  decode(day_translation_short[datetime.fromtimestamp(epg[key]['startts']).strftime('%w')]) + ' ' + datetime.fromtimestamp(epg[key]['startts']).strftime('%d.%m %H:%M') + ' - ' + datetime.fromtimestamp(epg[key]['endts']).strftime('%H:%M') + ')')
        list_item = epg_listitem(list_item = list_item, epg = epg[key], logo = '')
        list_item.setProperty('IsPlayable', 'true')
        list_item.setContentLookup(False)          
        url = get_url(action='play_recording', id = epg[key]['id'], start = epg[key]['startts'], end = epg[key]['endts'])
        xbmcplugin.addDirectoryItem(_handle, url, list_item, False)
    xbmcplugin.endOfDirectory(_handle, cacheToDisc = False)


    # data = o2api.call_o2_api(url = 'https://3201.frp1.ott.kaltura.com/api_v3/service/asset/action/list?format=1&clientTag=1.16.1-PC', data = post, headers = o2api.headers)

    # if 'objects' in data['result']:
    #     for item in data['result']['objects']:
    #         print(item)
    #         print(item['name'])


# {"language":"ces","ks":"djJ8MzIwMXwfL4dq7dGdAjIGcffiB5xF3EJa-owKpoaAkSaoEXZEKA0zeK1OIUYS9wKW1bAfiYiAA3NR4iK0djikEiPi1vHAIOBMG6qK0nvo_3bTjnl4lGRx-6TI-HHPybgwbp3rZ9LY-UF_qg8nHFHu9jbIHPLKZ_64-bj9JYYAUrECTCBfHac8ZN4VvBSvb9_qZdl7VsuCeUrTufWFLGbTLsZzzAXeKeB--iuVbQiTVvYCmIjFsL2irzZC1GcSJm2QXlYYKmpf5X6nhS0ofG9yQ5Q_62QZSNCjuUEpoul8Cj7E2YQPX8lBon6b18N11SzPGfrjulVDVZLb59StJN9vFuD3mgPq3mZKpHYjRyNnv1Q8OpPd8XrliQHNT3jTv09t3ExQ5XwUimcwJvk7IpD5zpKlIHrO","filter":{"objectType":"KalturaSearchAssetFilter","kSql":"(and (or CategoryId = '614739' CategoryId = '614396' CategoryId = '614395' CategoryId = '614388' CategoryId = '614389' CategoryId = '614390' CategoryId = '614391' CategoryId = '614392' CategoryId = '614393' CategoryId = '614394' CategoryId = '614406' CategoryId = '614397' CategoryId = '614398' CategoryId = '614399' CategoryId = '614400' CategoryId = '614401' CategoryId = '614402' CategoryId = '614403' CategoryId = '614745' CategoryId = '614404' CategoryId = '614405' CategoryId = '614416' CategoryId = '614407' CategoryId = '614408' CategoryId = '614409' CategoryId = '614410' CategoryId = '614411' CategoryId = '614412' CategoryId = '614413' CategoryId = '614414' CategoryId = '614415' CategoryId = '614426' CategoryId = '614417' CategoryId = '614418' CategoryId = '614419' CategoryId = '614420' CategoryId = '614421' CategoryId = '614422' CategoryId = '614423' CategoryId = '614424' CategoryId = '614425' CategoryId = '614436' CategoryId = '614427' CategoryId = '614744' CategoryId = '614428' CategoryId = '614429' CategoryId = '614430' CategoryId = '614431' CategoryId = '614432' CategoryId = '614433' CategoryId = '614434' CategoryId = '614435' CategoryId = '614444' CategoryId = '614437' CategoryId = '614438' CategoryId = '614439' CategoryId = '614440' CategoryId = '614441' CategoryId = '614442' CategoryId = '614443' CategoryId = '614446' CategoryId = '614445' CategoryId = '614463' CategoryId = '614450' CategoryId = '614447' CategoryId = '614448' CategoryId = '614449' CategoryId = '614451' CategoryId = '614452' CategoryId = '614453' CategoryId = '614454' CategoryId = '614455' CategoryId = '614456' CategoryId = '614457' CategoryId = '614458' CategoryId = '614460' CategoryId = '614459' CategoryId = '614461' CategoryId = '614462' CategoryId = '614464' CategoryId = '614472' CategoryId = '614465' CategoryId = '614466' CategoryId = '614467' CategoryId = '614468' CategoryId = '614469' CategoryId = '614470' CategoryId = '614471' CategoryId = '614482' CategoryId = '614481' CategoryId = '614473' CategoryId = '614474' CategoryId = '614475' CategoryId = '614476' CategoryId = '614477' CategoryId = '614478' CategoryId = '614479' CategoryId = '614480' CategoryId = '614494' CategoryId = '614483' CategoryId = '614484' CategoryId = '614485' CategoryId = '614486' CategoryId = '614487' CategoryId = '614488' CategoryId = '614489' CategoryId = '614490' CategoryId = '614491' CategoryId = '614492' CategoryId = '614493' CategoryId = '614512' CategoryId = '614495' CategoryId = '614496' CategoryId = '614497' CategoryId = '614498' CategoryId = '614499' CategoryId = '614500' CategoryId = '614501' CategoryId = '614502' CategoryId = '614503' CategoryId = '614504' CategoryId = '614505' CategoryId = '614506' CategoryId = '614507' CategoryId = '614508' CategoryId = '614509' CategoryId = '614510' CategoryId = '614511' CategoryId = '614516' CategoryId = '614513' CategoryId = '614514' CategoryId = '614515' CategoryId = '614520' CategoryId = '614517' CategoryId = '614518' CategoryId = '614519' CategoryId = '614524' CategoryId = '614521' CategoryId = '614522' CategoryId = '614523' CategoryId = '614528' CategoryId = '614525' CategoryId = '614526' CategoryId = '614527' CategoryId = '614532' CategoryId = '614529' CategoryId = '614530' CategoryId = '614531' CategoryId = '614544' CategoryId = '614533' CategoryId = '614534' CategoryId = '614535' CategoryId = '614536' CategoryId = '614537' CategoryId = '614538' CategoryId = '614539' CategoryId = '614540' CategoryId = '614541' CategoryId = '614542' CategoryId = '614543' CategoryId = '614550' CategoryId = '614545' CategoryId = '614546' CategoryId = '614547' CategoryId = '614548' CategoryId = '614549' CategoryId = '614554' CategoryId = '614551' CategoryId = '614552' CategoryId = '614553' CategoryId = '614558' CategoryId = '614555' CategoryId = '614556' CategoryId = '614557' CategoryId = '614562' CategoryId = '614559' CategoryId = '614560' CategoryId = '614561' CategoryId = '614566' CategoryId = '614563' CategoryId = '614564' CategoryId = '614565' CategoryId = '614570' CategoryId = '614567' CategoryId = '614568' CategoryId = '614569' CategoryId = '614573' CategoryId = '614571' CategoryId = '614572' CategoryId = '614575' CategoryId = '614574' CategoryId = '614576' CategoryId = '614591' CategoryId = '614577' CategoryId = '614581' CategoryId = '614582' CategoryId = '614583' CategoryId = '614584' CategoryId = '614585' CategoryId = '614586' CategoryId = '614587' CategoryId = '614588' CategoryId = '614589' CategoryId = '614590' CategoryId = '614596' CategoryId = '614592' CategoryId = '614593' CategoryId = '614594' CategoryId = '614595' CategoryId = '614598' CategoryId = '614597' CategoryId = '614600' CategoryId = '614599' CategoryId = '614604' CategoryId = '614601' CategoryId = '614602' CategoryId = '614603' CategoryId = '614611' CategoryId = '614605' CategoryId = '614606' CategoryId = '614607' CategoryId = '614608' CategoryId = '614609' CategoryId = '614610' CategoryId = '614615' CategoryId = '614612' CategoryId = '614613' CategoryId = '614614' CategoryId = '614619' CategoryId = '614616' CategoryId = '614617' CategoryId = '614618' CategoryId = '614623' CategoryId = '614620' CategoryId = '614621' CategoryId = '614622' CategoryId = '614627' CategoryId = '614624' CategoryId = '614625' CategoryId = '614626' CategoryId = '614631' CategoryId = '614628' CategoryId = '614629' CategoryId = '614630' CategoryId = '614635' CategoryId = '614632' CategoryId = '614633' CategoryId = '614634' CategoryId = '614639' CategoryId = '614636' CategoryId = '614637' CategoryId = '614638' CategoryId = '614643' CategoryId = '614640' CategoryId = '614641' CategoryId = '614642' CategoryId = '614647' CategoryId = '614644' CategoryId = '614645' CategoryId = '614646' CategoryId = '614651' CategoryId = '614648' CategoryId = '614649' CategoryId = '614650' CategoryId = '614655' CategoryId = '614652' CategoryId = '614653' CategoryId = '614654' CategoryId = '614659' CategoryId = '614656' CategoryId = '614657' CategoryId = '614658' CategoryId = '614663' CategoryId = '614660' CategoryId = '614661' CategoryId = '614662' CategoryId = '614680' CategoryId = '614664' CategoryId = '614665' CategoryId = '614666' CategoryId = '614667' CategoryId = '614668' CategoryId = '614669' CategoryId = '614670' CategoryId = '614671' CategoryId = '614672' CategoryId = '614673' CategoryId = '614674' CategoryId = '614675' CategoryId = '614676' CategoryId = '614677' CategoryId = '614678' CategoryId = '614679' CategoryId = '614689' CategoryId = '614681' CategoryId = '614682' CategoryId = '614683' CategoryId = '614684' CategoryId = '614685' CategoryId = '614686' CategoryId = '614687' CategoryId = '614688' CategoryId = '614697' CategoryId = '614690' CategoryId = '614691' CategoryId = '614692' CategoryId = '614693' CategoryId = '614694' CategoryId = '614695' CategoryId = '614696' CategoryId = '614701' CategoryId = '614698' CategoryId = '614699' CategoryId = '614700' CategoryId = '614705' CategoryId = '614702' CategoryId = '614703' CategoryId = '614704' CategoryId = '614709' CategoryId = '614706' CategoryId = '614707' CategoryId = '614708' CategoryId = '614713' CategoryId = '614710' CategoryId = '614711' CategoryId = '614712' CategoryId = '614717' CategoryId = '614714' CategoryId = '614715' CategoryId = '614716' CategoryId = '614721' CategoryId = '614718' CategoryId = '614719' CategoryId = '614720' CategoryId = '614725' CategoryId = '614722' CategoryId = '614723' CategoryId = '614724' CategoryId = '614729' CategoryId = '614726' CategoryId = '614727' CategoryId = '614728' CategoryId = '614733' CategoryId = '614730' CategoryId = '614731' CategoryId = '614732' CategoryId = '614738' CategoryId = '614734' CategoryId = '614735' CategoryId = '614736' CategoryId = '614737' CategoryId = '614740' CategoryId = '614741' CategoryId = '614742' CategoryId = '614743' )(or ))"},"pager":{"objectType":"KalturaFilterPager","pageSize":100,"pageIndex":4},"clientTag":"1.16.1-PC","apiVersion":"5.4.0"}
# Nejlepsi filmy
#    post = {"language":"ces","ks":session.ks,"responseProfile":{"objectType":"KalturaOnDemandResponseProfile","relatedProfiles":[{"objectType":"KalturaDetachedResponseProfile","name":"group_result","filter":{"objectType":"KalturaAggregationCountFilter"}}],"retrievedProperties":"assetId, assetType, duration, finishedWatching, position, watchedDate, mediaFiles,description,objectType,name,id,images,tags,metas,epgChannelId,enableCatchUp,enableCdvr,enableStartOver,enableTrickPlay,linearAssetId,type,updateDate,externalId,epgId,endDate,createDate,crid,startDate"},"filter":{"objectType":"KalturaChannelFilter","kSql":"(and ExternalProvider != 'hbo' adult!='1' entitled_assets='entitledSubscriptions' start_date>'-604801' )","groupBy":[{"objectType":"KalturaAssetMetaOrTagGroupBy","value":"name"}],"idEqual":359022},"pager":{"objectType":"KalturaFilterPager","pageSize":20,"pageIndex":1},"clientTag":"1.16.1-PC","apiVersion":"5.4.0"}

# Chci se koukat na ...
# 354976